

#property copyright ""
#property link      "" 


#property indicator_chart_window
#property indicator_buffers 5

#property indicator_color1  Green
#property indicator_color2  Maroon
#property indicator_color3  Lime
#property indicator_color4  Red
#property indicator_color5  CLR_NONE

#property indicator_width1  1
#property indicator_width2  1
#property indicator_width3  5
#property indicator_width4  5
#property indicator_width5  1


extern bool   Indicator_On                   = true;
extern bool   Use_For_Forex                  = true;
extern bool   Use_Day_Formula                = true;
extern string Exit_Period_Choices            = "M1, M5, M15, M30, H1, H4, D1";
extern string Exit_If_Period_Greater_Than    = "H1";
extern string _                              = "";
extern string Part_1                         = "Day Candle & Session Box Settings:";
extern bool   Show_DayCandle                 = true;
extern int    Shift_DayCandle_right          = 49;
extern bool   Show_Today_Box                 = true;
extern color  Today_Box_Color                = C'30,33,36';
extern bool   Show_Yesterday_Box             = true;
extern color  Yesterday_Box_Color            = C'20,18,41';
extern string __                             = "";
extern string Part_2                         = "Pivot Line Start/Stop Settings:";
extern string note1                          = "Start with fullscreen lines, enter '1'";
extern string note2                          = "Start lines at Day Separator, enter '2'";
extern string note3                          = "Start lines at current candle, enter '3'";
extern int    StartLines                     = 2;
extern bool   StopLines_At_Current_Candle    = false;
extern string ___                            = "";
extern string Part_3                         = "Pivot Line Color & Selection Settings:";
extern color  CentralPivot_Color             = Blue;
extern int    CP_LineStyle_01234             = 0;
extern int    CP_SolidLine_Thickness         = 1;
extern color  Resistance_Pivots_Color        = FireBrick;
extern int    R_LineStyle_01234              = 0;
extern int    R_SolidLineThickness           = 1; 
extern color  Support_Pivots_Color           = Green;
extern int    S_LineStyle_01234              = 0;
extern int    S_SolidLineThickness           = 1;
extern bool   Show_MidPivots                 = true;
extern color  MidPivots_Color                = C'108,108,0'; 
extern int    mP_LineStyle_01234             = 2;    
extern int    mP_SolidLineThickness          = 1;
extern string ____                           = "";
extern string Part_4                         = "Pivot Label Settings:";
extern color  PivotLabels_Color              = DarkGray;
extern string PivotLabels_FontStyle          = "Arial";
extern int    PivotLabels_Fontsize           = 9; 
extern bool   Show_Price_in_PivotLabels      = true;
extern string note4                          = "Show_RightMargin_Prices and";
extern string note5                          = "Shift_Pivotlabels_PerCent_Left";
extern string note6                          = "work only when lines are fullscreen.";
extern bool   Show_RightMargin_Prices        = true;
extern bool   Preeminate_MarginLabels_Lines  = true;
extern int    Shift_PivotLabels_PerCent_Left = 100;
extern bool   Subordinate_Labels             = false;
extern string _____                          = "";
extern string Part_5                         = "Today Separator Settings:";
extern bool   Show_Separator                 = true; 
extern color  Separator_Color                = C'108,108,0';
extern int    Separator_LineStyle_01234      = 2;
extern int    Separator_SolidLineThickness   = 2;
extern bool   Show_SeparatorLabel            = true;
extern color  SeparatorLabel_Color           = C'108,108,0'; 
extern string SeparatorLabel_FontStyle       = "Arial Bold";
extern int    SeparatorLabel_FontSize        = 11;
extern int    LabelOnChart_TopBot_12         = 2;
extern string ______                         = "";
extern string Part_6                         = "Data Comment Settings:"; 
extern bool   Show_Data_Comment              = true;
extern color  Data_Comment_Background_Color  = C'15,15,15';
extern int    Days_Used_For_Range_Data       = 30;

//Buffers, Constants and Variables
int      fxDigits,CalcPeriod,shift,dow,YesterdayBar,TodayBar;
datetime StartTime;
double   HiPrice,LoPrice,Range,ClosePrice,Pivot,R1,S1,R2,S2,R3,S3,R4,S4,R5,S5;
double   DayHigh[],DayLow[],DayOpen[],DayClose[],Old_Price;
string   Price;

//+-------------------------------------------------------------------------------------------+
//| Indicator Initialization                                                                  |                                                        
//+-------------------------------------------------------------------------------------------+      
int init()
   {
   if (Use_For_Forex)  {string sub=StringSubstr(Symbol(), 3, 3);
      if (sub == "JPY") {fxDigits = 2;} else {fxDigits = 4;}}
      
   SetIndexBuffer(0, DayHigh);
   SetIndexBuffer(1, DayLow);
   SetIndexBuffer(2, DayClose);
   SetIndexBuffer(3, DayOpen);
   
   if (Show_DayCandle){
      for (int i=0;i<4;i++){
         SetIndexStyle(i,DRAW_HISTOGRAM);
         SetIndexShift(i,Shift_DayCandle_right);
         SetIndexLabel(i,"[PivotsD] DayCandle");}}            
   else{for(i=0;i<4;i++) {SetIndexStyle(i,DRAW_NONE);}}      
   return(0);
   }

//+-------------------------------------------------------------------------------------------+
//| Indicator De-initialization                                                               |                                                        
//+-------------------------------------------------------------------------------------------+       
int deinit()
   {   
   int obj_total= ObjectsTotal();  
   for (int k= obj_total; k>=0; k--){
      string name= ObjectName(k); 
      if (StringSubstr(name,0,9)=="[PivotsD]"){ObjectDelete(name);}}
      Comment("");     
   return(0);
   }

//+-------------------------------------------------------------------------------------------+
//| Indicator Start                                                                           |                                                        
//+-------------------------------------------------------------------------------------------+         
int start()
   {
   deinit();if (Indicator_On == false) {return(0);}
         
   //Exit if period is greater than -----------------------------------------------
   int E;
   if(Exit_If_Period_Greater_Than== "M1") {E= 1;}
   if(Exit_If_Period_Greater_Than== "M5") {E= 5;}
   if(Exit_If_Period_Greater_Than== "M15") {E= 15;}
   if(Exit_If_Period_Greater_Than== "M30") {E= 30;}
   if(Exit_If_Period_Greater_Than== "H1") {E= 60;}
   if(Exit_If_Period_Greater_Than== "H4") {E= 240;}
   if(Exit_If_Period_Greater_Than== "D1") {E= 1440;}
   if(Period() > E) {deinit(); return(-1);}    
   
   //Code for Pivots---------------------------------------------------------------------------
	string pLineStr,pStr,p,s1Str,S1LineStr,s1,r1Str,R1LineStr,r1;
	string s2Str,S2LineStr,s2,r2Str,R2LineStr,r2; 
	string s3Str,S3LineStr,s3,r3Str,R3LineStr,r3;
	string s4Str,S4LineStr,s4,r4Str,R4LineStr,r4;
	string s5Str,S5LineStr,s5,r5Str,R5LineStr,r5;
	string mrLineStr;
	
      if(Use_Day_Formula){ 
         pLineStr  = "    DPV";
         S1LineStr = "    DS1";
         R1LineStr = "    DR1";
         S2LineStr = "    DS2";
         R2LineStr = "    DR2";
         S3LineStr = "    DS3";
         R3LineStr = "    DR3";
         mrLineStr = "    m";}       
      else{ 
         pLineStr  = "    FPV";
         S1LineStr = "    FS1";
         R1LineStr = "    FR1";
         S2LineStr = "    FS2";
         R2LineStr = "    FR2";
         S3LineStr = "    FS3";
         R3LineStr = "    FR3";
         S4LineStr = "    FS4";
         R4LineStr = "    FR4";
         S5LineStr = "    FS5";
         R5LineStr = "    FR5";
         mrLineStr = "    m";}
    
   CalcPeriod = 1440;       
   shift	= iBarShift(NULL,CalcPeriod,Time[0])+ 1;//default = one period ago	 
	StartTime = iTime(NULL,CalcPeriod,shift);	 
	dow = TimeDayOfWeek(StartTime);string dowStr;
	   switch(dow)
	      {
   	   case 5: dowStr = "Monday";break;
   	   //Monday = Friday value 2 periods ago 
         case 0: shift=iBarShift(NULL,CalcPeriod,Time[0])+2; dowStr = "Monday"; break;
         case 1: dowStr = "Tuesday"; break;       
         case 2: dowStr = "Wednesday"; break;
         case 3: dowStr = "Thursday"; break;
         case 4: dowStr = "Friday"; break;	 	   
         } 	     
 	ClosePrice  = NormalizeDouble(iClose(NULL,CalcPeriod,shift),4);
   HiPrice     = NormalizeDouble (iHigh(NULL,CalcPeriod,shift),4); 
   LoPrice     = NormalizeDouble (iLow(NULL,CalcPeriod,shift),4);
   Range       = HiPrice -  LoPrice;
   Pivot       = NormalizeDouble((HiPrice+LoPrice+ClosePrice)/3,4);
      
   if(Use_Day_Formula){
      R1 = (2*Pivot)-LoPrice;
      S1 = (2*Pivot)-HiPrice;
      R2 = Pivot+(R1-S1);
      S2 = Pivot-(R1-S1); 
      R3 = ( 2.0 * Pivot) + ( HiPrice - ( 2.0 * LoPrice ) );
      S3 = ( 2.0 * Pivot) - ( ( 2.0 * HiPrice ) - LoPrice );}      

   else{ 
      R5 = Pivot + (Range  * 2.618);
      R4 = Pivot + (Range  * 1.618);
      R3 = Pivot +  Range ;     
      R2 = Pivot + (Range  * 0.618);
      R1 = Pivot + (Range  * 0.382);
      S1 = Pivot - (Range  * 0.382);      
      S2 = Pivot - (Range  * 0.618);       
      S3 = Pivot -  Range ;     
      S4 = Pivot - (Range  * 1.618);    
      S5 = Pivot - (Range  * 2.618);}
    
   //Main Pivots-------------------------------------------------------------------------------   
   if(CP_LineStyle_01234>0){CP_SolidLine_Thickness=0;}
   if(R_LineStyle_01234>0){R_SolidLineThickness=0;} 
   if(S_LineStyle_01234>0){S_SolidLineThickness=0;}
  
   drawLine("R3", R3, Resistance_Pivots_Color,R_LineStyle_01234,R_SolidLineThickness); 
   drawLabel( R3LineStr,R3,PivotLabels_Color);
   drawLine("R2", R2, Resistance_Pivots_Color,R_LineStyle_01234,R_SolidLineThickness);
   drawLabel(R2LineStr,R2,PivotLabels_Color);
   drawLine("R1", R1, Resistance_Pivots_Color,R_LineStyle_01234,R_SolidLineThickness);
   drawLabel(R1LineStr,R1,PivotLabels_Color);
   drawLine("PIVOT", Pivot,CentralPivot_Color,CP_LineStyle_01234,CP_SolidLine_Thickness);
   drawLabel(pLineStr, Pivot,PivotLabels_Color);
   drawLine("S1", S1, Support_Pivots_Color,S_LineStyle_01234,S_SolidLineThickness);
   drawLabel(S1LineStr,S1,PivotLabels_Color);
   drawLine("S2", S2, Support_Pivots_Color,S_LineStyle_01234,S_SolidLineThickness);
   drawLabel(S2LineStr,S2,PivotLabels_Color);
   drawLine("S3", S3, Support_Pivots_Color,S_LineStyle_01234,S_SolidLineThickness);
   drawLabel(S3LineStr ,S3,PivotLabels_Color);
     
   if(Use_Day_Formula==false){
   drawLine("R5", R5, Resistance_Pivots_Color,R_LineStyle_01234,R_SolidLineThickness); 
   drawLabel( R5LineStr,R5,PivotLabels_Color);
   drawLine("R4", R4, Resistance_Pivots_Color,R_LineStyle_01234,R_SolidLineThickness);
   drawLabel(R4LineStr,R4,PivotLabels_Color);
   drawLine("S4", S4, Support_Pivots_Color,S_LineStyle_01234,S_SolidLineThickness);
   drawLabel(S4LineStr,S4,PivotLabels_Color);
   drawLine("S5", S5, Support_Pivots_Color,S_LineStyle_01234,S_SolidLineThickness);
   drawLabel(S5LineStr ,S5,PivotLabels_Color);}
   
   //Mid Pivots--------------------------------------------------------------------------------
   if(Show_MidPivots){
   if(mP_LineStyle_01234>0){mP_SolidLineThickness=0;}
   
   drawLine("MR3", (R2+R3)/2, MidPivots_Color,mP_LineStyle_01234,mP_SolidLineThickness); 
   drawLabel(mrLineStr+"R3",(R2+R3)/2,PivotLabels_Color);
   drawLine("MR2", (R1+R2)/2, MidPivots_Color,mP_LineStyle_01234,mP_SolidLineThickness); 
   drawLabel(mrLineStr+"R2",(R1+R2)/2,PivotLabels_Color); 
   drawLine("MR1", (Pivot+R1)/2, MidPivots_Color,mP_LineStyle_01234,mP_SolidLineThickness); 
   drawLabel(mrLineStr+"R1",(Pivot+R1)/2,PivotLabels_Color);
   drawLine("MS1", (Pivot+S1)/2, MidPivots_Color,mP_LineStyle_01234,mP_SolidLineThickness); 
   drawLabel(mrLineStr+"S1",(Pivot+S1)/2,PivotLabels_Color);
   drawLine("MS2", (S1+S2)/2, MidPivots_Color,mP_LineStyle_01234,mP_SolidLineThickness); 
   drawLabel(mrLineStr+"S2",(S1+S2)/2,PivotLabels_Color);
   drawLine("MS3", (S2+S3)/2, MidPivots_Color,mP_LineStyle_01234,mP_SolidLineThickness); 
   drawLabel(mrLineStr+"S3",(S2+S3)/2,PivotLabels_Color);
     
   if(Use_Day_Formula==false){   
   drawLine("MR5", (R4+R5)/2, MidPivots_Color,mP_LineStyle_01234,mP_SolidLineThickness); 
   drawLabel(mrLineStr+"R5",(R4+R5)/2,PivotLabels_Color);
   drawLine("MR4", (R3+R4)/2, MidPivots_Color,mP_LineStyle_01234,mP_SolidLineThickness); 
   drawLabel(mrLineStr+"R4",(R3+R4)/2,PivotLabels_Color); 
   drawLine("MS4", (S3+S4)/2, MidPivots_Color,mP_LineStyle_01234,mP_SolidLineThickness); 
   drawLabel(mrLineStr+"S4",(S3+S4)/2,PivotLabels_Color);
   drawLine("MS5", (S4+S5)/2, MidPivots_Color,mP_LineStyle_01234,mP_SolidLineThickness); 
   drawLabel(mrLineStr+"S5",(S4+S5)/2,PivotLabels_Color);}}
     
   //Show Today Separator vertical line--------------------------------------------------------
   if(Show_Separator){
      if(Show_SeparatorLabel){
      double top = WindowPriceMax();
      double bottom = WindowPriceMin();
     	double scale = top - bottom;	
      double YadjustTop = scale/5000; //250;
      double YadjustBot = scale/(350/SeparatorLabel_FontSize); 	
      double level = top - YadjustTop;  if (LabelOnChart_TopBot_12==2){level = bottom + YadjustBot;}}
   Separator(" Today Separator", dowStr, iTime(NULL, PERIOD_D1,0),Separator_Color,
   Separator_LineStyle_01234, Separator_SolidLineThickness, level);}   
          
   //Code for TF Background colors and Day Candle----------------------------------------------
   int digits = MarketInfo(Symbol(),MODE_DIGITS);
   double modifier = 1; if (digits==3 || digits==5) modifier = 10.0;
   
   //Define today's bar and it's data                     
   TodayBar          = iBarShift(NULL,PERIOD_D1,Time[0]);
   double HiToday    = iHigh (NULL,PERIOD_D1,TodayBar);
   double LoToday    = iLow  (NULL,PERIOD_D1,TodayBar); 
   double open       = iOpen( NULL,PERIOD_D1,TodayBar);
   double current    = iClose(NULL,PERIOD_D1,TodayBar);
   double change     = (current-iOpen(NULL,PERIOD_D1,TodayBar))/(Point*modifier);
   double startToday = iTime(NULL,PERIOD_D1,TodayBar);
   double endToday   = iTime(NULL,0,0);
      
   //Define yesterday's bar and it's data              
   YesterdayBar = iBarShift(NULL,PERIOD_D1,Time[(23*60)/Period()]);
   double HiYesterday    = iHigh (NULL,PERIOD_D1,YesterdayBar);
   double LoYesterday    = iLow  (NULL,PERIOD_D1,YesterdayBar);
   double startYesterday = iTime(NULL,PERIOD_D1,YesterdayBar);
   double endYesterday   = iTime(NULL,PERIOD_D1,TodayBar);
      
   if(Show_DayCandle){
      int shift = 0; if (change>0) {DayHigh[shift] = HiToday;  DayLow[shift] = LoToday;}            
      else  {DayHigh[shift] = LoToday; DayLow[shift] = HiToday;}            
      DayClose[shift] = current; DayOpen[shift] = open+0.000001;                  
      int i,limit; for(i=0,limit=Bars-1;i<4;i++) SetIndexDrawBegin(i,limit);}
      
   if (Show_Today_Box)   
   colorTFbox ("[PivotsD] TFBoxToday", startToday, endToday, HiToday, LoToday, Today_Box_Color);  
   
   if (Show_Yesterday_Box)   
   colorTFbox ("[PivotsD] TFBoxYesterday", startYesterday, endYesterday, HiYesterday, LoYesterday, Yesterday_Box_Color);   
            
   //Data Box section--------------------------------------------------------------------------
   if (Show_Data_Comment){
      string dComment = "[PivotsD] Data Box";       
      ObjectCreate(dComment, OBJ_LABEL, 0, 0, 0, 0, 0);
      ObjectSetText(dComment, "g", 92, "Webdings");
      ObjectSet(dComment, OBJPROP_CORNER, 0);
      ObjectSet(dComment, OBJPROP_XDISTANCE, 0);
      ObjectSet(dComment, OBJPROP_YDISTANCE, 13 );      
      ObjectSet(dComment, OBJPROP_COLOR, Data_Comment_Background_Color);
      ObjectSet(dComment, OBJPROP_BACK, false);
      //Daily Average Range
      int Ra=0, RaP=Days_Used_For_Range_Data;
      for(i=0; i<RaP; i++) {Ra = Ra + ((iHigh(NULL,PERIOD_D1,i)- iLow(NULL,PERIOD_D1,i))/Point);}
      Ra = ((Ra/RaP)+1); //Add "1" to balance excessive rounding down       
      //Get time (H/M/S) remaining on current candle		
   	int h,m,s,t;    
      t=Time[0]+(Period()*60)-CurTime();
      s=t%60; string seconds = (s); if (s<10) {seconds = ("0"+seconds);} 
      m=(t-t%60)/60;   
      for(i=0; i<24; i++){
         if(m>=60){m=m-60;h=h+1;}
         string minutes = (m); if (m<10) {minutes = ("0"+minutes);}   
         string hours = (h); if (h<10) {hours = ("0"+hours);} 
         string timeleft = (minutes+":"+seconds);
         if (h>=1) {timeleft = (hours+":"+minutes+":"+seconds);}
         if (Period()>1440){timeleft = "OFF";}}  	    
      //Spread
      int spread = MarketInfo(Symbol(), MODE_SPREAD); 
      //Set up Comment string     
      string C= "\n --------  Pivots Daily Targets  --------\n";  
      C=C + "   Range  Today:   "+DoubleToStr(MathRound((HiToday-LoToday)/Point),0)+ "\n";  
      C=C + "         Yesterday:   "+DoubleToStr(MathRound((HiYesterday-LoYesterday)/Point),0) + "\n";            
      C=C + "   "+Days_Used_For_Range_Data+" Day Range:   "+ Ra + "\n";
      C=C + "       Next Bar In:   " + timeleft + "\n";       
      C=C + "             Spread:    " + spread + "\n"; 
      C=C + "       Swap  Long:   "+DoubleToStr(MarketInfo(Symbol(),MODE_SWAPLONG),2) + "\n";
      C=C + "      Swap  Short:   "+DoubleToStr(MarketInfo(Symbol(),MODE_SWAPSHORT),2) + "\n";                 
      Comment(C);}
         
   //End of program computations---------------------------------------------------------------        
   return(0);
   } 

//+-------------------------------------------------------------------------------------------+
//| drawLabel sub-routine to name and draw labels for pivot lines                             |                                                        
//+-------------------------------------------------------------------------------------------+ 
void drawLabel(string text, double level, color Color)
   {  
   //Define name and content of the pivot line labels
   string plabel = "[PivotsD] " + text + " Label";
   if (Use_For_Forex) {Price=DoubleToStr(level, fxDigits);}
   else {Price=DoubleToStr(level, Digits);}    
   if (Show_Price_in_PivotLabels && StrToInteger(text)==0) {text = text + "   " + Price;}   
   
   //Determine start time for labels   
   if (Shift_PivotLabels_PerCent_Left < 0)   {Shift_PivotLabels_PerCent_Left =0;}
   if (Shift_PivotLabels_PerCent_Left > 100) {Shift_PivotLabels_PerCent_Left =100;}
   int L, LabelsShift = (WindowFirstVisibleBar()*Shift_PivotLabels_PerCent_Left)/100;
   
   //Initiate needed time variables
   int time, startday = Time[1]; 
   if (Time[0] > iTime(NULL, PERIOD_D1, 0)){startday = iTime(NULL, PERIOD_D1, 0);} 
           
   //Set tabs required for desired label text alignment 
   string tab; 
   if (StartLines==1) L= 1;
   if (StartLines==2 && startday<=iTime(NULL,0,WindowFirstVisibleBar()) ) L= 1;
   if (L==1){
      time= Time[LabelsShift];
      if (Show_Price_in_PivotLabels){tab="                                 ";}       //33                    
      else {tab = "                 ";}}                                             //17                    
   else { 
      if (Show_Price_in_PivotLabels){tab="                              ";}          //30
      else {tab = "              ";}                                                 //14
      if (StartLines==2){time= startday;}
      else {time= Time[0];}}      

   //Draw the labels
   if(ObjectFind(plabel) != 0){      
      ObjectCreate(plabel, OBJ_TEXT, 0, time, level);       
      ObjectSetText(plabel, tab+text, PivotLabels_Fontsize, PivotLabels_FontStyle, Color);
      ObjectSet(plabel, OBJPROP_BACK, false);
      if(Subordinate_Labels) {ObjectSet(plabel, OBJPROP_BACK, true);}} 
   else{ObjectMove(plabel, 0, time, level);}            
   }

//+-------------------------------------------------------------------------------------------+
//| drawline sub-routine to name and draw pivot lines                                         |                                                        
//+-------------------------------------------------------------------------------------------+      
void drawLine(string text, double level, color Color, int linestyle, int thickness)
   {
   //Define line labels
   string pline = "[PivotsD] " + text + " Line";   
   
   //Define line configuration variables  
   int a = linestyle;
   int b = thickness;
   int c =1; if (a==0)c=b; 
   int F= false;//F= true= ray line
   int G= true; //G= true= subordinated lines
   int Z= OBJ_TREND; 
 
   //Define needed time variables 
   int start, stop, startday = Time[1];
   if (Time[1] >= iTime(NULL,PERIOD_D1,0)) startday = iTime(NULL,PERIOD_D1,0);
 
   //Order varibles needed to create/move lines     
   int L; if (StartLines==1) L= 1;
   if (StartLines==2 && startday<=iTime(NULL,0,WindowFirstVisibleBar())) L= 1;
   if (L==1) {{start= iTime(NULL,0,WindowFirstVisibleBar()); stop= Time[0]; F=true;}
      if (Show_RightMargin_Prices) {Z = OBJ_HLINE; 
         if (Preeminate_MarginLabels_Lines) G= false;}}       
   else {if (StartLines==2) {start= startday; stop= Time[0]; Z= OBJ_TREND; F= true;}
   else {if (StartLines==3) {start= Time[1]; stop= Time[0]; Z= OBJ_TREND; F= true;} }}
   if (StopLines_At_Current_Candle && StartLines != 3) {Z= OBJ_TREND; F=false;}
   //Draw lines        
   if(ObjectFind(pline) != 0){
      ObjectCreate(pline, Z, 0, start, level, stop, level);                            
      ObjectSet(pline, OBJPROP_STYLE, a);              
      ObjectSet(pline, OBJPROP_WIDTH, c);     
      ObjectSet(pline, OBJPROP_COLOR, Color);
      ObjectSet(pline, OBJPROP_BACK, G);
      ObjectSet(pline, OBJPROP_RAY, F);}      
   //Move lines      
   else{
      ObjectMove(pline, 0, start, level);         
      ObjectMove(pline, 1, stop, level);}  
   }

//+-------------------------------------------------------------------------------------------+
//| colorTFbox sub-routine to draw colored background for yesterday & today sessions          |                                                 
//+-------------------------------------------------------------------------------------------+      
void colorTFbox (string name, double starttime, double endtime, double high, double low, color Color)
   {
   string TFbox = "[PivotsD] " + name;
   if (ObjectFind(TFbox) != 0){
      ObjectCreate(TFbox,OBJ_RECTANGLE,0,0,0);
      ObjectSet(TFbox,OBJPROP_TIME1,starttime);
      ObjectSet(TFbox,OBJPROP_TIME2,endtime);
      ObjectSet(TFbox,OBJPROP_PRICE1,high);
      ObjectSet(TFbox,OBJPROP_PRICE2,low);
      ObjectSet(TFbox,OBJPROP_COLOR,Color);}
   else{      
      ObjectMove(TFbox, 1, starttime, high);
      ObjectMove(TFbox, 0, endtime, low);}                             
   }

//+-------------------------------------------------------------------------------------------+
//| Separator sub-routine to name and draw Today Separator line and label                     |          
//+-------------------------------------------------------------------------------------------+   
void Separator(string name, string text, datetime T, color Color, int linestyle, int thickness, double level) 
   {
   int a = linestyle;
   int b = thickness;
   int c =1; if (a==0)c=b;    
   string vline= "[PivotsD] " + name, vlabel = vline + " Label";
   
   if (ObjectFind(vline) != 0){ 
      ObjectCreate(vline, OBJ_TREND, 0, T, 0, T, 100);
      ObjectSet(vline, OBJPROP_STYLE, a);    
      ObjectSet(vline, OBJPROP_WIDTH, c);
      ObjectSet(vline, OBJPROP_COLOR, Color);
      ObjectSet(vline, OBJPROP_BACK, true); }
   else{
      ObjectMove(vline, 0, T, 0); 
      ObjectMove(vline, 1, T, 100);}  
  
   if(Show_SeparatorLabel){                         
      if (ObjectFind(vlabel) != 0) {
         ObjectCreate (vlabel, OBJ_TEXT, 0, T, level);
         ObjectSetText(vlabel, text, SeparatorLabel_FontSize, SeparatorLabel_FontStyle, SeparatorLabel_Color); 
         ObjectSet(vlabel, OBJPROP_BACK, false);
         if(Subordinate_Labels) {ObjectSet(vlabel, OBJPROP_BACK, true);}}        
      else{ObjectMove(vlabel, 0, T, level);}}                              
   }

//+-------------------------------------------------------------------------------------------+
//| End of Program                                                                            |                                                        
//+-------------------------------------------------------------------------------------------+      

